package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PendingCloudwatchLogsExports(
    logTypesToEnable: Option[Iterable[String]] = None,
    logTypesToDisable: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports = {
    import PendingCloudwatchLogsExports.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports
      .builder()
      .optionallyWith(
        logTypesToEnable.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.logTypesToEnable)
      .optionallyWith(
        logTypesToDisable.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.logTypesToDisable)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.PendingCloudwatchLogsExports.ReadOnly =
    zio.aws.docdb.model.PendingCloudwatchLogsExports.wrap(buildAwsValue())
}
object PendingCloudwatchLogsExports {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.PendingCloudwatchLogsExports =
      zio.aws.docdb.model.PendingCloudwatchLogsExports(
        logTypesToEnable.map(value => value),
        logTypesToDisable.map(value => value)
      )
    def logTypesToEnable: Option[List[String]]
    def logTypesToDisable: Option[List[String]]
    def getLogTypesToEnable: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("logTypesToEnable", logTypesToEnable)
    def getLogTypesToDisable: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("logTypesToDisable", logTypesToDisable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports
  ) extends zio.aws.docdb.model.PendingCloudwatchLogsExports.ReadOnly {
    override val logTypesToEnable: Option[List[String]] = scala
      .Option(impl.logTypesToEnable())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val logTypesToDisable: Option[List[String]] = scala
      .Option(impl.logTypesToDisable())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports
  ): zio.aws.docdb.model.PendingCloudwatchLogsExports.ReadOnly = new Wrapper(
    impl
  )
}
