package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.{IntegerOptional, BooleanOptional}
import scala.jdk.CollectionConverters._
final case class ModifyDbInstanceRequest(
    dbInstanceIdentifier: String,
    dbInstanceClass: Option[String] = None,
    applyImmediately: Option[Boolean] = None,
    preferredMaintenanceWindow: Option[String] = None,
    autoMinorVersionUpgrade: Option[BooleanOptional] = None,
    newDBInstanceIdentifier: Option[String] = None,
    caCertificateIdentifier: Option[String] = None,
    promotionTier: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest = {
    import ModifyDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        newDBInstanceIdentifier.map(value => value: java.lang.String)
      )(_.newDBInstanceIdentifier)
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(promotionTier.map(value => value: Integer))(
        _.promotionTier
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.ModifyDbInstanceRequest.ReadOnly =
    zio.aws.docdb.model.ModifyDbInstanceRequest.wrap(buildAwsValue())
}
object ModifyDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ModifyDbInstanceRequest =
      zio.aws.docdb.model.ModifyDbInstanceRequest(
        dbInstanceIdentifier,
        dbInstanceClass.map(value => value),
        applyImmediately.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        newDBInstanceIdentifier.map(value => value),
        caCertificateIdentifier.map(value => value),
        promotionTier.map(value => value)
      )
    def dbInstanceIdentifier: String
    def dbInstanceClass: Option[String]
    def applyImmediately: Option[Boolean]
    def preferredMaintenanceWindow: Option[String]
    def autoMinorVersionUpgrade: Option[BooleanOptional]
    def newDBInstanceIdentifier: Option[String]
    def caCertificateIdentifier: Option[String]
    def promotionTier: Option[IntegerOptional]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getNewDBInstanceIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("newDBInstanceIdentifier", newDBInstanceIdentifier)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest
  ) extends zio.aws.docdb.model.ModifyDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val dbInstanceClass: Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val applyImmediately: Option[Boolean] =
      scala.Option(impl.applyImmediately()).map(value => value: Boolean)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => value: BooleanOptional)
    override val newDBInstanceIdentifier: Option[String] =
      scala.Option(impl.newDBInstanceIdentifier()).map(value => value: String)
    override val caCertificateIdentifier: Option[String] =
      scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
    override val promotionTier: Option[IntegerOptional] =
      scala.Option(impl.promotionTier()).map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest
  ): zio.aws.docdb.model.ModifyDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
