package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GlobalClusterMember(
    dbClusterArn: Option[String] = None,
    readers: Option[Iterable[String]] = None,
    isWriter: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.GlobalClusterMember = {
    import GlobalClusterMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.GlobalClusterMember
      .builder()
      .optionallyWith(dbClusterArn.map(value => value: java.lang.String))(
        _.dbClusterArn
      )
      .optionallyWith(
        readers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readers)
      .optionallyWith(isWriter.map(value => value: java.lang.Boolean))(
        _.isWriter
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.GlobalClusterMember.ReadOnly =
    zio.aws.docdb.model.GlobalClusterMember.wrap(buildAwsValue())
}
object GlobalClusterMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.GlobalClusterMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.GlobalClusterMember =
      zio.aws.docdb.model.GlobalClusterMember(
        dbClusterArn.map(value => value),
        readers.map(value => value),
        isWriter.map(value => value)
      )
    def dbClusterArn: Option[String]
    def readers: Option[List[String]]
    def isWriter: Option[Boolean]
    def getDbClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterArn", dbClusterArn)
    def getReaders: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("readers", readers)
    def getIsWriter: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isWriter", isWriter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.GlobalClusterMember
  ) extends zio.aws.docdb.model.GlobalClusterMember.ReadOnly {
    override val dbClusterArn: Option[String] =
      scala.Option(impl.dbClusterArn()).map(value => value: String)
    override val readers: Option[List[String]] = scala
      .Option(impl.readers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val isWriter: Option[Boolean] =
      scala.Option(impl.isWriter()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.GlobalClusterMember
  ): zio.aws.docdb.model.GlobalClusterMember.ReadOnly = new Wrapper(impl)
}
