package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EventSubscription(
    customerAwsId: Option[String] = None,
    custSubscriptionId: Option[String] = None,
    snsTopicArn: Option[String] = None,
    status: Option[String] = None,
    subscriptionCreationTime: Option[String] = None,
    sourceType: Option[String] = None,
    sourceIdsList: Option[Iterable[String]] = None,
    eventCategoriesList: Option[Iterable[String]] = None,
    enabled: Option[Boolean] = None,
    eventSubscriptionArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.EventSubscription = {
    import EventSubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.EventSubscription
      .builder()
      .optionallyWith(customerAwsId.map(value => value: java.lang.String))(
        _.customerAwsId
      )
      .optionallyWith(custSubscriptionId.map(value => value: java.lang.String))(
        _.custSubscriptionId
      )
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        subscriptionCreationTime.map(value => value: java.lang.String)
      )(_.subscriptionCreationTime)
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        sourceIdsList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourceIdsList)
      .optionallyWith(
        eventCategoriesList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategoriesList)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        eventSubscriptionArn.map(value => value: java.lang.String)
      )(_.eventSubscriptionArn)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.EventSubscription.ReadOnly =
    zio.aws.docdb.model.EventSubscription.wrap(buildAwsValue())
}
object EventSubscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.EventSubscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.EventSubscription =
      zio.aws.docdb.model.EventSubscription(
        customerAwsId.map(value => value),
        custSubscriptionId.map(value => value),
        snsTopicArn.map(value => value),
        status.map(value => value),
        subscriptionCreationTime.map(value => value),
        sourceType.map(value => value),
        sourceIdsList.map(value => value),
        eventCategoriesList.map(value => value),
        enabled.map(value => value),
        eventSubscriptionArn.map(value => value)
      )
    def customerAwsId: Option[String]
    def custSubscriptionId: Option[String]
    def snsTopicArn: Option[String]
    def status: Option[String]
    def subscriptionCreationTime: Option[String]
    def sourceType: Option[String]
    def sourceIdsList: Option[List[String]]
    def eventCategoriesList: Option[List[String]]
    def enabled: Option[Boolean]
    def eventSubscriptionArn: Option[String]
    def getCustomerAwsId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerAwsId", customerAwsId)
    def getCustSubscriptionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("custSubscriptionId", custSubscriptionId)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSubscriptionCreationTime: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("subscriptionCreationTime", subscriptionCreationTime)
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getSourceIdsList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourceIdsList", sourceIdsList)
    def getEventCategoriesList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategoriesList", eventCategoriesList)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getEventSubscriptionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventSubscriptionArn", eventSubscriptionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.EventSubscription
  ) extends zio.aws.docdb.model.EventSubscription.ReadOnly {
    override val customerAwsId: Option[String] =
      scala.Option(impl.customerAwsId()).map(value => value: String)
    override val custSubscriptionId: Option[String] =
      scala.Option(impl.custSubscriptionId()).map(value => value: String)
    override val snsTopicArn: Option[String] =
      scala.Option(impl.snsTopicArn()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val subscriptionCreationTime: Option[String] =
      scala.Option(impl.subscriptionCreationTime()).map(value => value: String)
    override val sourceType: Option[String] =
      scala.Option(impl.sourceType()).map(value => value: String)
    override val sourceIdsList: Option[List[String]] = scala
      .Option(impl.sourceIdsList())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val eventCategoriesList: Option[List[String]] = scala
      .Option(impl.eventCategoriesList())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val eventSubscriptionArn: Option[String] =
      scala.Option(impl.eventSubscriptionArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.EventSubscription
  ): zio.aws.docdb.model.EventSubscription.ReadOnly = new Wrapper(impl)
}
