package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class DescribePendingMaintenanceActionsRequest(
    resourceIdentifier: Option[String] = None,
    filters: Option[Iterable[zio.aws.docdb.model.Filter]] = None,
    marker: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest = {
    import DescribePendingMaintenanceActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest
      .builder()
      .optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(
        _.resourceIdentifier
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.DescribePendingMaintenanceActionsRequest.ReadOnly =
    zio.aws.docdb.model.DescribePendingMaintenanceActionsRequest
      .wrap(buildAwsValue())
}
object DescribePendingMaintenanceActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.docdb.model.DescribePendingMaintenanceActionsRequest =
      zio.aws.docdb.model.DescribePendingMaintenanceActionsRequest(
        resourceIdentifier.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value),
        maxRecords.map(value => value)
      )
    def resourceIdentifier: Option[String]
    def filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]]
    def marker: Option[String]
    def maxRecords: Option[IntegerOptional]
    def getResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest
  ) extends zio.aws.docdb.model.DescribePendingMaintenanceActionsRequest.ReadOnly {
    override val resourceIdentifier: Option[String] =
      scala.Option(impl.resourceIdentifier()).map(value => value: String)
    override val filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Filter.wrap(item)
          }.toList
        )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest
  ): zio.aws.docdb.model.DescribePendingMaintenanceActionsRequest.ReadOnly =
    new Wrapper(impl)
}
