package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterParameterGroupsResponse(
    marker: Option[String] = None,
    dbClusterParameterGroups: Option[
      Iterable[zio.aws.docdb.model.DBClusterParameterGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse = {
    import DescribeDbClusterParameterGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbClusterParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterParameterGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse.ReadOnly =
    zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeDbClusterParameterGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse =
      zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse(
        marker.map(value => value),
        dbClusterParameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def dbClusterParameterGroups
        : Option[List[zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbClusterParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbClusterParameterGroups",
      dbClusterParameterGroups
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse
  ) extends zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val dbClusterParameterGroups
        : Option[List[zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly]] =
      scala
        .Option(impl.dbClusterParameterGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.DBClusterParameterGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse
  ): zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
