package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDbInstanceRequest(dbInstanceIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest = {
    import DeleteDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DeleteDbInstanceRequest.ReadOnly =
    zio.aws.docdb.model.DeleteDbInstanceRequest.wrap(buildAwsValue())
}
object DeleteDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DeleteDbInstanceRequest =
      zio.aws.docdb.model.DeleteDbInstanceRequest(dbInstanceIdentifier)
    def dbInstanceIdentifier: String
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest
  ) extends zio.aws.docdb.model.DeleteDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest
  ): zio.aws.docdb.model.DeleteDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
