package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteDbClusterRequest(
    dbClusterIdentifier: String,
    skipFinalSnapshot: Option[Boolean] = None,
    finalDBSnapshotIdentifier: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest = {
    import DeleteDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(skipFinalSnapshot.map(value => value: java.lang.Boolean))(
        _.skipFinalSnapshot
      )
      .optionallyWith(
        finalDBSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.finalDBSnapshotIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DeleteDbClusterRequest.ReadOnly =
    zio.aws.docdb.model.DeleteDbClusterRequest.wrap(buildAwsValue())
}
object DeleteDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DeleteDbClusterRequest =
      zio.aws.docdb.model.DeleteDbClusterRequest(
        dbClusterIdentifier,
        skipFinalSnapshot.map(value => value),
        finalDBSnapshotIdentifier.map(value => value)
      )
    def dbClusterIdentifier: String
    def skipFinalSnapshot: Option[Boolean]
    def finalDBSnapshotIdentifier: Option[String]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getSkipFinalSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("skipFinalSnapshot", skipFinalSnapshot)
    def getFinalDBSnapshotIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("finalDBSnapshotIdentifier", finalDBSnapshotIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest
  ) extends zio.aws.docdb.model.DeleteDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val skipFinalSnapshot: Option[Boolean] =
      scala.Option(impl.skipFinalSnapshot()).map(value => value: Boolean)
    override val finalDBSnapshotIdentifier: Option[String] =
      scala.Option(impl.finalDBSnapshotIdentifier()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest
  ): zio.aws.docdb.model.DeleteDbClusterRequest.ReadOnly = new Wrapper(impl)
}
