package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DBClusterRole(
    roleArn: Option[String] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBClusterRole = {
    import DBClusterRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBClusterRole
      .builder()
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBClusterRole.ReadOnly =
    zio.aws.docdb.model.DBClusterRole.wrap(buildAwsValue())
}
object DBClusterRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DBClusterRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBClusterRole = zio.aws.docdb.model
      .DBClusterRole(roleArn.map(value => value), status.map(value => value))
    def roleArn: Option[String]
    def status: Option[String]
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterRole
  ) extends zio.aws.docdb.model.DBClusterRole.ReadOnly {
    override val roleArn: Option[String] =
      scala.Option(impl.roleArn()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterRole
  ): zio.aws.docdb.model.DBClusterRole.ReadOnly = new Wrapper(impl)
}
