package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters._
final case class CreateEventSubscriptionRequest(
    subscriptionName: String,
    snsTopicArn: String,
    sourceType: Option[String] = None,
    eventCategories: Option[Iterable[String]] = None,
    sourceIds: Option[Iterable[String]] = None,
    enabled: Option[BooleanOptional] = None,
    tags: Option[Iterable[zio.aws.docdb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CreateEventSubscriptionRequest = {
    import CreateEventSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateEventSubscriptionRequest
      .builder()
      .subscriptionName(subscriptionName: java.lang.String)
      .snsTopicArn(snsTopicArn: java.lang.String)
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .optionallyWith(
        sourceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourceIds)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.CreateEventSubscriptionRequest.ReadOnly =
    zio.aws.docdb.model.CreateEventSubscriptionRequest.wrap(buildAwsValue())
}
object CreateEventSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CreateEventSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CreateEventSubscriptionRequest =
      zio.aws.docdb.model.CreateEventSubscriptionRequest(
        subscriptionName,
        snsTopicArn,
        sourceType.map(value => value),
        eventCategories.map(value => value),
        sourceIds.map(value => value),
        enabled.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subscriptionName: String
    def snsTopicArn: String
    def sourceType: Option[String]
    def eventCategories: Option[List[String]]
    def sourceIds: Option[List[String]]
    def enabled: Option[BooleanOptional]
    def tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]]
    def getSubscriptionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subscriptionName)
    def getSnsTopicArn: ZIO[Any, Nothing, String] = ZIO.succeed(snsTopicArn)
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
    def getSourceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourceIds", sourceIds)
    def getEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getTags: ZIO[Any, AwsError, List[zio.aws.docdb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CreateEventSubscriptionRequest
  ) extends zio.aws.docdb.model.CreateEventSubscriptionRequest.ReadOnly {
    override val subscriptionName: String = impl.subscriptionName(): String
    override val snsTopicArn: String = impl.snsTopicArn(): String
    override val sourceType: Option[String] =
      scala.Option(impl.sourceType()).map(value => value: String)
    override val eventCategories: Option[List[String]] = scala
      .Option(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val sourceIds: Option[List[String]] = scala
      .Option(impl.sourceIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val enabled: Option[BooleanOptional] =
      scala.Option(impl.enabled()).map(value => value: BooleanOptional)
    override val tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CreateEventSubscriptionRequest
  ): zio.aws.docdb.model.CreateEventSubscriptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
