package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApplyPendingMaintenanceActionResponse(
    resourcePendingMaintenanceActions: Option[
      zio.aws.docdb.model.ResourcePendingMaintenanceActions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionResponse = {
    import ApplyPendingMaintenanceActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionResponse
      .builder()
      .optionallyWith(
        resourcePendingMaintenanceActions.map(value => value.buildAwsValue())
      )(_.resourcePendingMaintenanceActions)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.ApplyPendingMaintenanceActionResponse.ReadOnly =
    zio.aws.docdb.model.ApplyPendingMaintenanceActionResponse
      .wrap(buildAwsValue())
}
object ApplyPendingMaintenanceActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ApplyPendingMaintenanceActionResponse =
      zio.aws.docdb.model.ApplyPendingMaintenanceActionResponse(
        resourcePendingMaintenanceActions.map(value => value.asEditable)
      )
    def resourcePendingMaintenanceActions
        : Option[zio.aws.docdb.model.ResourcePendingMaintenanceActions.ReadOnly]
    def getResourcePendingMaintenanceActions: ZIO[
      Any,
      AwsError,
      zio.aws.docdb.model.ResourcePendingMaintenanceActions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourcePendingMaintenanceActions",
      resourcePendingMaintenanceActions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionResponse
  ) extends zio.aws.docdb.model.ApplyPendingMaintenanceActionResponse.ReadOnly {
    override val resourcePendingMaintenanceActions: Option[
      zio.aws.docdb.model.ResourcePendingMaintenanceActions.ReadOnly
    ] = scala
      .Option(impl.resourcePendingMaintenanceActions())
      .map(value =>
        zio.aws.docdb.model.ResourcePendingMaintenanceActions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionResponse
  ): zio.aws.docdb.model.ApplyPendingMaintenanceActionResponse.ReadOnly =
    new Wrapper(impl)
}
