package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RemoveSourceIdentifierFromSubscriptionResponse(
    eventSubscription: Option[zio.aws.docdb.model.EventSubscription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse = {
    import RemoveSourceIdentifierFromSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse
      .builder()
      .optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(
        _.eventSubscription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly =
    zio.aws.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse
      .wrap(buildAwsValue())
}
object RemoveSourceIdentifierFromSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse =
      zio.aws.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse(
        eventSubscription.map(value => value.asEditable)
      )
    def eventSubscription
        : Option[zio.aws.docdb.model.EventSubscription.ReadOnly]
    def getEventSubscription
        : ZIO[Any, AwsError, zio.aws.docdb.model.EventSubscription.ReadOnly] =
      AwsError.unwrapOptionField("eventSubscription", eventSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse
  ) extends zio.aws.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly {
    override val eventSubscription
        : Option[zio.aws.docdb.model.EventSubscription.ReadOnly] = scala
      .Option(impl.eventSubscription())
      .map(value => zio.aws.docdb.model.EventSubscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse
  ): zio.aws.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
