package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.{BooleanOptional, IntegerOptional}
import scala.jdk.CollectionConverters._
final case class PendingModifiedValues(
    dbInstanceClass: Option[String] = None,
    allocatedStorage: Option[IntegerOptional] = None,
    masterUserPassword: Option[String] = None,
    port: Option[IntegerOptional] = None,
    backupRetentionPeriod: Option[IntegerOptional] = None,
    multiAZ: Option[BooleanOptional] = None,
    engineVersion: Option[String] = None,
    licenseModel: Option[String] = None,
    iops: Option[IntegerOptional] = None,
    dbInstanceIdentifier: Option[String] = None,
    storageType: Option[String] = None,
    caCertificateIdentifier: Option[String] = None,
    dbSubnetGroupName: Option[String] = None,
    pendingCloudwatchLogsExports: Option[
      zio.aws.docdb.model.PendingCloudwatchLogsExports
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.PendingModifiedValues = {
    import PendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.PendingModifiedValues
      .builder()
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        pendingCloudwatchLogsExports.map(value => value.buildAwsValue())
      )(_.pendingCloudwatchLogsExports)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.PendingModifiedValues.ReadOnly =
    zio.aws.docdb.model.PendingModifiedValues.wrap(buildAwsValue())
}
object PendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.PendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.PendingModifiedValues =
      zio.aws.docdb.model.PendingModifiedValues(
        dbInstanceClass.map(value => value),
        allocatedStorage.map(value => value),
        masterUserPassword.map(value => value),
        port.map(value => value),
        backupRetentionPeriod.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        dbInstanceIdentifier.map(value => value),
        storageType.map(value => value),
        caCertificateIdentifier.map(value => value),
        dbSubnetGroupName.map(value => value),
        pendingCloudwatchLogsExports.map(value => value.asEditable)
      )
    def dbInstanceClass: Option[String]
    def allocatedStorage: Option[IntegerOptional]
    def masterUserPassword: Option[String]
    def port: Option[IntegerOptional]
    def backupRetentionPeriod: Option[IntegerOptional]
    def multiAZ: Option[BooleanOptional]
    def engineVersion: Option[String]
    def licenseModel: Option[String]
    def iops: Option[IntegerOptional]
    def dbInstanceIdentifier: Option[String]
    def storageType: Option[String]
    def caCertificateIdentifier: Option[String]
    def dbSubnetGroupName: Option[String]
    def pendingCloudwatchLogsExports
        : Option[zio.aws.docdb.model.PendingCloudwatchLogsExports.ReadOnly]
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getPendingCloudwatchLogsExports: ZIO[
      Any,
      AwsError,
      zio.aws.docdb.model.PendingCloudwatchLogsExports.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pendingCloudwatchLogsExports",
      pendingCloudwatchLogsExports
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.PendingModifiedValues
  ) extends zio.aws.docdb.model.PendingModifiedValues.ReadOnly {
    override val dbInstanceClass: Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val allocatedStorage: Option[IntegerOptional] =
      scala.Option(impl.allocatedStorage()).map(value => value: IntegerOptional)
    override val masterUserPassword: Option[String] =
      scala.Option(impl.masterUserPassword()).map(value => value: String)
    override val port: Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override val backupRetentionPeriod: Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => value: IntegerOptional)
    override val multiAZ: Option[BooleanOptional] =
      scala.Option(impl.multiAZ()).map(value => value: BooleanOptional)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val licenseModel: Option[String] =
      scala.Option(impl.licenseModel()).map(value => value: String)
    override val iops: Option[IntegerOptional] =
      scala.Option(impl.iops()).map(value => value: IntegerOptional)
    override val dbInstanceIdentifier: Option[String] =
      scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override val storageType: Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val caCertificateIdentifier: Option[String] =
      scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
    override val dbSubnetGroupName: Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val pendingCloudwatchLogsExports
        : Option[zio.aws.docdb.model.PendingCloudwatchLogsExports.ReadOnly] =
      scala
        .Option(impl.pendingCloudwatchLogsExports())
        .map(value =>
          zio.aws.docdb.model.PendingCloudwatchLogsExports.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.PendingModifiedValues
  ): zio.aws.docdb.model.PendingModifiedValues.ReadOnly = new Wrapper(impl)
}
