package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.{BooleanOptional, IntegerOptional}
import scala.jdk.CollectionConverters._
final case class DescribeDbEngineVersionsRequest(
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    dbParameterGroupFamily: Option[String] = None,
    filters: Option[Iterable[zio.aws.docdb.model.Filter]] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None,
    defaultOnly: Option[Boolean] = None,
    listSupportedCharacterSets: Option[BooleanOptional] = None,
    listSupportedTimezones: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest = {
    import DescribeDbEngineVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(defaultOnly.map(value => value: java.lang.Boolean))(
        _.defaultOnly
      )
      .optionallyWith(
        listSupportedCharacterSets.map(value => value: java.lang.Boolean)
      )(_.listSupportedCharacterSets)
      .optionallyWith(
        listSupportedTimezones.map(value => value: java.lang.Boolean)
      )(_.listSupportedTimezones)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DescribeDbEngineVersionsRequest.ReadOnly =
    zio.aws.docdb.model.DescribeDbEngineVersionsRequest.wrap(buildAwsValue())
}
object DescribeDbEngineVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DescribeDbEngineVersionsRequest =
      zio.aws.docdb.model.DescribeDbEngineVersionsRequest(
        engine.map(value => value),
        engineVersion.map(value => value),
        dbParameterGroupFamily.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value),
        defaultOnly.map(value => value),
        listSupportedCharacterSets.map(value => value),
        listSupportedTimezones.map(value => value)
      )
    def engine: Option[String]
    def engineVersion: Option[String]
    def dbParameterGroupFamily: Option[String]
    def filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def defaultOnly: Option[Boolean]
    def listSupportedCharacterSets: Option[BooleanOptional]
    def listSupportedTimezones: Option[BooleanOptional]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDefaultOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultOnly", defaultOnly)
    def getListSupportedCharacterSets: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "listSupportedCharacterSets",
        listSupportedCharacterSets
      )
    def getListSupportedTimezones: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "listSupportedTimezones",
        listSupportedTimezones
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest
  ) extends zio.aws.docdb.model.DescribeDbEngineVersionsRequest.ReadOnly {
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val dbParameterGroupFamily: Option[String] =
      scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
    override val filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val defaultOnly: Option[Boolean] =
      scala.Option(impl.defaultOnly()).map(value => value: Boolean)
    override val listSupportedCharacterSets: Option[BooleanOptional] = scala
      .Option(impl.listSupportedCharacterSets())
      .map(value => value: BooleanOptional)
    override val listSupportedTimezones: Option[BooleanOptional] = scala
      .Option(impl.listSupportedTimezones())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest
  ): zio.aws.docdb.model.DescribeDbEngineVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
