package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class DescribeDbClustersRequest(
    dbClusterIdentifier: Option[String] = None,
    filters: Option[Iterable[zio.aws.docdb.model.Filter]] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest = {
    import DescribeDbClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest
      .builder()
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DescribeDbClustersRequest.ReadOnly =
    zio.aws.docdb.model.DescribeDbClustersRequest.wrap(buildAwsValue())
}
object DescribeDbClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DescribeDbClustersRequest =
      zio.aws.docdb.model.DescribeDbClustersRequest(
        dbClusterIdentifier.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def dbClusterIdentifier: Option[String]
    def filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest
  ) extends zio.aws.docdb.model.DescribeDbClustersRequest.ReadOnly {
    override val dbClusterIdentifier: Option[String] =
      scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override val filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest
  ): zio.aws.docdb.model.DescribeDbClustersRequest.ReadOnly = new Wrapper(impl)
}
