package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterSnapshotsRequest(
    dbClusterIdentifier: Option[String] = None,
    dbClusterSnapshotIdentifier: Option[String] = None,
    snapshotType: Option[String] = None,
    filters: Option[Iterable[zio.aws.docdb.model.Filter]] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None,
    includeShared: Option[Boolean] = None,
    includePublic: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest = {
    import DescribeDbClusterSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest
      .builder()
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbClusterSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterSnapshotIdentifier)
      .optionallyWith(snapshotType.map(value => value: java.lang.String))(
        _.snapshotType
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(includeShared.map(value => value: java.lang.Boolean))(
        _.includeShared
      )
      .optionallyWith(includePublic.map(value => value: java.lang.Boolean))(
        _.includePublic
      )
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.DescribeDbClusterSnapshotsRequest.ReadOnly =
    zio.aws.docdb.model.DescribeDbClusterSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeDbClusterSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DescribeDbClusterSnapshotsRequest =
      zio.aws.docdb.model.DescribeDbClusterSnapshotsRequest(
        dbClusterIdentifier.map(value => value),
        dbClusterSnapshotIdentifier.map(value => value),
        snapshotType.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value),
        includeShared.map(value => value),
        includePublic.map(value => value)
      )
    def dbClusterIdentifier: Option[String]
    def dbClusterSnapshotIdentifier: Option[String]
    def snapshotType: Option[String]
    def filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def includeShared: Option[Boolean]
    def includePublic: Option[Boolean]
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbClusterSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterSnapshotIdentifier",
        dbClusterSnapshotIdentifier
      )
    def getSnapshotType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getIncludeShared: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeShared", includeShared)
    def getIncludePublic: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includePublic", includePublic)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest
  ) extends zio.aws.docdb.model.DescribeDbClusterSnapshotsRequest.ReadOnly {
    override val dbClusterIdentifier: Option[String] =
      scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override val dbClusterSnapshotIdentifier: Option[String] = scala
      .Option(impl.dbClusterSnapshotIdentifier())
      .map(value => value: String)
    override val snapshotType: Option[String] =
      scala.Option(impl.snapshotType()).map(value => value: String)
    override val filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val includeShared: Option[Boolean] =
      scala.Option(impl.includeShared()).map(value => value: Boolean)
    override val includePublic: Option[Boolean] =
      scala.Option(impl.includePublic()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest
  ): zio.aws.docdb.model.DescribeDbClusterSnapshotsRequest.ReadOnly =
    new Wrapper(impl)
}
