package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterSnapshotAttributesResponse(
    dbClusterSnapshotAttributesResult: Option[
      zio.aws.docdb.model.DBClusterSnapshotAttributesResult
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesResponse = {
    import DescribeDbClusterSnapshotAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesResponse
      .builder()
      .optionallyWith(
        dbClusterSnapshotAttributesResult.map(value => value.buildAwsValue())
      )(_.dbClusterSnapshotAttributesResult)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly =
    zio.aws.docdb.model.DescribeDbClusterSnapshotAttributesResponse
      .wrap(buildAwsValue())
}
object DescribeDbClusterSnapshotAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.docdb.model.DescribeDbClusterSnapshotAttributesResponse =
      zio.aws.docdb.model.DescribeDbClusterSnapshotAttributesResponse(
        dbClusterSnapshotAttributesResult.map(value => value.asEditable)
      )
    def dbClusterSnapshotAttributesResult
        : Option[zio.aws.docdb.model.DBClusterSnapshotAttributesResult.ReadOnly]
    def getDbClusterSnapshotAttributesResult: ZIO[
      Any,
      AwsError,
      zio.aws.docdb.model.DBClusterSnapshotAttributesResult.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbClusterSnapshotAttributesResult",
      dbClusterSnapshotAttributesResult
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesResponse
  ) extends zio.aws.docdb.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly {
    override val dbClusterSnapshotAttributesResult: Option[
      zio.aws.docdb.model.DBClusterSnapshotAttributesResult.ReadOnly
    ] = scala
      .Option(impl.dbClusterSnapshotAttributesResult())
      .map(value =>
        zio.aws.docdb.model.DBClusterSnapshotAttributesResult.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesResponse
  ): zio.aws.docdb.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
