package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteDbClusterSnapshotResponse(
    dbClusterSnapshot: Option[zio.aws.docdb.model.DBClusterSnapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotResponse = {
    import DeleteDbClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotResponse
      .builder()
      .optionallyWith(dbClusterSnapshot.map(value => value.buildAwsValue()))(
        _.dbClusterSnapshot
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DeleteDbClusterSnapshotResponse.ReadOnly =
    zio.aws.docdb.model.DeleteDbClusterSnapshotResponse.wrap(buildAwsValue())
}
object DeleteDbClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DeleteDbClusterSnapshotResponse =
      zio.aws.docdb.model.DeleteDbClusterSnapshotResponse(
        dbClusterSnapshot.map(value => value.asEditable)
      )
    def dbClusterSnapshot
        : Option[zio.aws.docdb.model.DBClusterSnapshot.ReadOnly]
    def getDbClusterSnapshot
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBClusterSnapshot.ReadOnly] =
      AwsError.unwrapOptionField("dbClusterSnapshot", dbClusterSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotResponse
  ) extends zio.aws.docdb.model.DeleteDbClusterSnapshotResponse.ReadOnly {
    override val dbClusterSnapshot
        : Option[zio.aws.docdb.model.DBClusterSnapshot.ReadOnly] = scala
      .Option(impl.dbClusterSnapshot())
      .map(value => zio.aws.docdb.model.DBClusterSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotResponse
  ): zio.aws.docdb.model.DeleteDbClusterSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
