package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DBInstanceStatusInfo(
    statusType: Option[String] = None,
    normal: Option[Boolean] = None,
    status: Option[String] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo = {
    import DBInstanceStatusInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo
      .builder()
      .optionallyWith(statusType.map(value => value: java.lang.String))(
        _.statusType
      )
      .optionallyWith(normal.map(value => value: java.lang.Boolean))(_.normal)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBInstanceStatusInfo.ReadOnly =
    zio.aws.docdb.model.DBInstanceStatusInfo.wrap(buildAwsValue())
}
object DBInstanceStatusInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBInstanceStatusInfo =
      zio.aws.docdb.model.DBInstanceStatusInfo(
        statusType.map(value => value),
        normal.map(value => value),
        status.map(value => value),
        message.map(value => value)
      )
    def statusType: Option[String]
    def normal: Option[Boolean]
    def status: Option[String]
    def message: Option[String]
    def getStatusType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusType", statusType)
    def getNormal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("normal", normal)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo
  ) extends zio.aws.docdb.model.DBInstanceStatusInfo.ReadOnly {
    override val statusType: Option[String] =
      scala.Option(impl.statusType()).map(value => value: String)
    override val normal: Option[Boolean] =
      scala.Option(impl.normal()).map(value => value: Boolean)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo
  ): zio.aws.docdb.model.DBInstanceStatusInfo.ReadOnly = new Wrapper(impl)
}
