package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.docdb.model.primitives.{IntegerOptional, Integer, TStamp}
import scala.jdk.CollectionConverters._
final case class DBInstance(
    dbInstanceIdentifier: Option[String] = None,
    dbInstanceClass: Option[String] = None,
    engine: Option[String] = None,
    dbInstanceStatus: Option[String] = None,
    endpoint: Option[zio.aws.docdb.model.Endpoint] = None,
    instanceCreateTime: Option[TStamp] = None,
    preferredBackupWindow: Option[String] = None,
    backupRetentionPeriod: Option[Integer] = None,
    vpcSecurityGroups: Option[
      Iterable[zio.aws.docdb.model.VpcSecurityGroupMembership]
    ] = None,
    availabilityZone: Option[String] = None,
    dbSubnetGroup: Option[zio.aws.docdb.model.DBSubnetGroup] = None,
    preferredMaintenanceWindow: Option[String] = None,
    pendingModifiedValues: Option[zio.aws.docdb.model.PendingModifiedValues] =
      None,
    latestRestorableTime: Option[TStamp] = None,
    engineVersion: Option[String] = None,
    autoMinorVersionUpgrade: Option[Boolean] = None,
    publiclyAccessible: Option[Boolean] = None,
    statusInfos: Option[Iterable[zio.aws.docdb.model.DBInstanceStatusInfo]] =
      None,
    dbClusterIdentifier: Option[String] = None,
    storageEncrypted: Option[Boolean] = None,
    kmsKeyId: Option[String] = None,
    dbiResourceId: Option[String] = None,
    caCertificateIdentifier: Option[String] = None,
    promotionTier: Option[IntegerOptional] = None,
    dbInstanceArn: Option[String] = None,
    enabledCloudwatchLogsExports: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBInstance = {
    import DBInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBInstance
      .builder()
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(dbInstanceStatus.map(value => value: java.lang.String))(
        _.dbInstanceStatus
      )
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        instanceCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.instanceCreateTime)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        backupRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.backupRetentionPeriod)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        latestRestorableTime.map(value => TStamp.unwrap(value): Instant)
      )(_.latestRestorableTime)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        statusInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statusInfos)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(dbiResourceId.map(value => value: java.lang.String))(
        _.dbiResourceId
      )
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(promotionTier.map(value => value: java.lang.Integer))(
        _.promotionTier
      )
      .optionallyWith(dbInstanceArn.map(value => value: java.lang.String))(
        _.dbInstanceArn
      )
      .optionallyWith(
        enabledCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enabledCloudwatchLogsExports)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBInstance.ReadOnly =
    zio.aws.docdb.model.DBInstance.wrap(buildAwsValue())
}
object DBInstance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.docdb.model.DBInstance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBInstance =
      zio.aws.docdb.model.DBInstance(
        dbInstanceIdentifier.map(value => value),
        dbInstanceClass.map(value => value),
        engine.map(value => value),
        dbInstanceStatus.map(value => value),
        endpoint.map(value => value.asEditable),
        instanceCreateTime.map(value => value),
        preferredBackupWindow.map(value => value),
        backupRetentionPeriod.map(value => value),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZone.map(value => value),
        dbSubnetGroup.map(value => value.asEditable),
        preferredMaintenanceWindow.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        latestRestorableTime.map(value => value),
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        publiclyAccessible.map(value => value),
        statusInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbClusterIdentifier.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        dbiResourceId.map(value => value),
        caCertificateIdentifier.map(value => value),
        promotionTier.map(value => value),
        dbInstanceArn.map(value => value),
        enabledCloudwatchLogsExports.map(value => value)
      )
    def dbInstanceIdentifier: Option[String]
    def dbInstanceClass: Option[String]
    def engine: Option[String]
    def dbInstanceStatus: Option[String]
    def endpoint: Option[zio.aws.docdb.model.Endpoint.ReadOnly]
    def instanceCreateTime: Option[TStamp]
    def preferredBackupWindow: Option[String]
    def backupRetentionPeriod: Option[Integer]
    def vpcSecurityGroups
        : Option[List[zio.aws.docdb.model.VpcSecurityGroupMembership.ReadOnly]]
    def availabilityZone: Option[String]
    def dbSubnetGroup: Option[zio.aws.docdb.model.DBSubnetGroup.ReadOnly]
    def preferredMaintenanceWindow: Option[String]
    def pendingModifiedValues
        : Option[zio.aws.docdb.model.PendingModifiedValues.ReadOnly]
    def latestRestorableTime: Option[TStamp]
    def engineVersion: Option[String]
    def autoMinorVersionUpgrade: Option[Boolean]
    def publiclyAccessible: Option[Boolean]
    def statusInfos
        : Option[List[zio.aws.docdb.model.DBInstanceStatusInfo.ReadOnly]]
    def dbClusterIdentifier: Option[String]
    def storageEncrypted: Option[Boolean]
    def kmsKeyId: Option[String]
    def dbiResourceId: Option[String]
    def caCertificateIdentifier: Option[String]
    def promotionTier: Option[IntegerOptional]
    def dbInstanceArn: Option[String]
    def enabledCloudwatchLogsExports: Option[List[String]]
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getDbInstanceStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceStatus", dbInstanceStatus)
    def getEndpoint: ZIO[Any, AwsError, zio.aws.docdb.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getInstanceCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDbSubnetGroup
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBSubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.docdb.model.PendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getLatestRestorableTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTime)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getStatusInfos: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.DBInstanceStatusInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("statusInfos", statusInfos)
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
    def getDbInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceArn", dbInstanceArn)
    def getEnabledCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enabledCloudwatchLogsExports",
        enabledCloudwatchLogsExports
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBInstance
  ) extends zio.aws.docdb.model.DBInstance.ReadOnly {
    override val dbInstanceIdentifier: Option[String] =
      scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override val dbInstanceClass: Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val dbInstanceStatus: Option[String] =
      scala.Option(impl.dbInstanceStatus()).map(value => value: String)
    override val endpoint: Option[zio.aws.docdb.model.Endpoint.ReadOnly] = scala
      .Option(impl.endpoint())
      .map(value => zio.aws.docdb.model.Endpoint.wrap(value))
    override val instanceCreateTime: Option[TStamp] = scala
      .Option(impl.instanceCreateTime())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val preferredBackupWindow: Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override val backupRetentionPeriod: Option[Integer] =
      scala.Option(impl.backupRetentionPeriod()).map(value => value: Integer)
    override val vpcSecurityGroups: Option[
      List[zio.aws.docdb.model.VpcSecurityGroupMembership.ReadOnly]
    ] = scala
      .Option(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val dbSubnetGroup
        : Option[zio.aws.docdb.model.DBSubnetGroup.ReadOnly] = scala
      .Option(impl.dbSubnetGroup())
      .map(value => zio.aws.docdb.model.DBSubnetGroup.wrap(value))
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val pendingModifiedValues
        : Option[zio.aws.docdb.model.PendingModifiedValues.ReadOnly] = scala
      .Option(impl.pendingModifiedValues())
      .map(value => zio.aws.docdb.model.PendingModifiedValues.wrap(value))
    override val latestRestorableTime: Option[TStamp] = scala
      .Option(impl.latestRestorableTime())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val autoMinorVersionUpgrade: Option[Boolean] =
      scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: Boolean)
    override val publiclyAccessible: Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override val statusInfos
        : Option[List[zio.aws.docdb.model.DBInstanceStatusInfo.ReadOnly]] =
      scala
        .Option(impl.statusInfos())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.DBInstanceStatusInfo.wrap(item)
          }.toList
        )
    override val dbClusterIdentifier: Option[String] =
      scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override val storageEncrypted: Option[Boolean] =
      scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val dbiResourceId: Option[String] =
      scala.Option(impl.dbiResourceId()).map(value => value: String)
    override val caCertificateIdentifier: Option[String] =
      scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
    override val promotionTier: Option[IntegerOptional] =
      scala.Option(impl.promotionTier()).map(value => value: IntegerOptional)
    override val dbInstanceArn: Option[String] =
      scala.Option(impl.dbInstanceArn()).map(value => value: String)
    override val enabledCloudwatchLogsExports: Option[List[String]] = scala
      .Option(impl.enabledCloudwatchLogsExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBInstance
  ): zio.aws.docdb.model.DBInstance.ReadOnly = new Wrapper(impl)
}
