package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDbClusterSnapshotResponse(
    dbClusterSnapshot: Option[zio.aws.docdb.model.DBClusterSnapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse = {
    import CreateDbClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse
      .builder()
      .optionallyWith(dbClusterSnapshot.map(value => value.buildAwsValue()))(
        _.dbClusterSnapshot
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.CreateDbClusterSnapshotResponse.ReadOnly =
    zio.aws.docdb.model.CreateDbClusterSnapshotResponse.wrap(buildAwsValue())
}
object CreateDbClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CreateDbClusterSnapshotResponse =
      zio.aws.docdb.model.CreateDbClusterSnapshotResponse(
        dbClusterSnapshot.map(value => value.asEditable)
      )
    def dbClusterSnapshot
        : Option[zio.aws.docdb.model.DBClusterSnapshot.ReadOnly]
    def getDbClusterSnapshot
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBClusterSnapshot.ReadOnly] =
      AwsError.unwrapOptionField("dbClusterSnapshot", dbClusterSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse
  ) extends zio.aws.docdb.model.CreateDbClusterSnapshotResponse.ReadOnly {
    override val dbClusterSnapshot
        : Option[zio.aws.docdb.model.DBClusterSnapshot.ReadOnly] = scala
      .Option(impl.dbClusterSnapshot())
      .map(value => zio.aws.docdb.model.DBClusterSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse
  ): zio.aws.docdb.model.CreateDbClusterSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
