package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.{
  GlobalClusterIdentifier,
  BooleanOptional,
  IntegerOptional
}
import scala.jdk.CollectionConverters._
final case class CreateDbClusterRequest(
    availabilityZones: Option[Iterable[String]] = None,
    backupRetentionPeriod: Option[IntegerOptional] = None,
    dbClusterIdentifier: String,
    dbClusterParameterGroupName: Option[String] = None,
    vpcSecurityGroupIds: Option[Iterable[String]] = None,
    dbSubnetGroupName: Option[String] = None,
    engine: String,
    engineVersion: Option[String] = None,
    port: Option[IntegerOptional] = None,
    masterUsername: Option[String] = None,
    masterUserPassword: Option[String] = None,
    preferredBackupWindow: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    tags: Option[Iterable[zio.aws.docdb.model.Tag]] = None,
    storageEncrypted: Option[BooleanOptional] = None,
    kmsKeyId: Option[String] = None,
    preSignedUrl: Option[String] = None,
    enableCloudwatchLogsExports: Option[Iterable[String]] = None,
    deletionProtection: Option[BooleanOptional] = None,
    globalClusterIdentifier: Option[GlobalClusterIdentifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest = {
    import CreateDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .engine(engine: java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(preSignedUrl.map(value => value: java.lang.String))(
        _.preSignedUrl
      )
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        globalClusterIdentifier.map(value =>
          GlobalClusterIdentifier.unwrap(value): java.lang.String
        )
      )(_.globalClusterIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.CreateDbClusterRequest.ReadOnly =
    zio.aws.docdb.model.CreateDbClusterRequest.wrap(buildAwsValue())
}
object CreateDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CreateDbClusterRequest =
      zio.aws.docdb.model.CreateDbClusterRequest(
        availabilityZones.map(value => value),
        backupRetentionPeriod.map(value => value),
        dbClusterIdentifier,
        dbClusterParameterGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        dbSubnetGroupName.map(value => value),
        engine,
        engineVersion.map(value => value),
        port.map(value => value),
        masterUsername.map(value => value),
        masterUserPassword.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        preSignedUrl.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        deletionProtection.map(value => value),
        globalClusterIdentifier.map(value => value)
      )
    def availabilityZones: Option[List[String]]
    def backupRetentionPeriod: Option[IntegerOptional]
    def dbClusterIdentifier: String
    def dbClusterParameterGroupName: Option[String]
    def vpcSecurityGroupIds: Option[List[String]]
    def dbSubnetGroupName: Option[String]
    def engine: String
    def engineVersion: Option[String]
    def port: Option[IntegerOptional]
    def masterUsername: Option[String]
    def masterUserPassword: Option[String]
    def preferredBackupWindow: Option[String]
    def preferredMaintenanceWindow: Option[String]
    def tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]]
    def storageEncrypted: Option[BooleanOptional]
    def kmsKeyId: Option[String]
    def preSignedUrl: Option[String]
    def enableCloudwatchLogsExports: Option[List[String]]
    def deletionProtection: Option[BooleanOptional]
    def globalClusterIdentifier: Option[GlobalClusterIdentifier]
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.docdb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPreSignedUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getGlobalClusterIdentifier
        : ZIO[Any, AwsError, GlobalClusterIdentifier] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest
  ) extends zio.aws.docdb.model.CreateDbClusterRequest.ReadOnly {
    override val availabilityZones: Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val backupRetentionPeriod: Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => value: IntegerOptional)
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val dbClusterParameterGroupName: Option[String] = scala
      .Option(impl.dbClusterParameterGroupName())
      .map(value => value: String)
    override val vpcSecurityGroupIds: Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dbSubnetGroupName: Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val engine: String = impl.engine(): String
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val port: Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override val masterUsername: Option[String] =
      scala.Option(impl.masterUsername()).map(value => value: String)
    override val masterUserPassword: Option[String] =
      scala.Option(impl.masterUserPassword()).map(value => value: String)
    override val preferredBackupWindow: Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.Tag.wrap(item)
        }.toList
      )
    override val storageEncrypted: Option[BooleanOptional] =
      scala.Option(impl.storageEncrypted()).map(value => value: BooleanOptional)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val preSignedUrl: Option[String] =
      scala.Option(impl.preSignedUrl()).map(value => value: String)
    override val enableCloudwatchLogsExports: Option[List[String]] = scala
      .Option(impl.enableCloudwatchLogsExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val deletionProtection: Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => value: BooleanOptional)
    override val globalClusterIdentifier: Option[GlobalClusterIdentifier] =
      scala
        .Option(impl.globalClusterIdentifier())
        .map(value =>
          zio.aws.docdb.model.primitives.GlobalClusterIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest
  ): zio.aws.docdb.model.CreateDbClusterRequest.ReadOnly = new Wrapper(impl)
}
