package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.docdb.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class Certificate(
    certificateIdentifier: Option[String] = None,
    certificateType: Option[String] = None,
    thumbprint: Option[String] = None,
    validFrom: Option[TStamp] = None,
    validTill: Option[TStamp] = None,
    certificateArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Certificate
      .builder()
      .optionallyWith(
        certificateIdentifier.map(value => value: java.lang.String)
      )(_.certificateIdentifier)
      .optionallyWith(certificateType.map(value => value: java.lang.String))(
        _.certificateType
      )
      .optionallyWith(thumbprint.map(value => value: java.lang.String))(
        _.thumbprint
      )
      .optionallyWith(validFrom.map(value => TStamp.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validTill.map(value => TStamp.unwrap(value): Instant))(
        _.validTill
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.Certificate.ReadOnly =
    zio.aws.docdb.model.Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.docdb.model.Certificate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.Certificate =
      zio.aws.docdb.model.Certificate(
        certificateIdentifier.map(value => value),
        certificateType.map(value => value),
        thumbprint.map(value => value),
        validFrom.map(value => value),
        validTill.map(value => value),
        certificateArn.map(value => value)
      )
    def certificateIdentifier: Option[String]
    def certificateType: Option[String]
    def thumbprint: Option[String]
    def validFrom: Option[TStamp]
    def validTill: Option[TStamp]
    def certificateArn: Option[String]
    def getCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateIdentifier", certificateIdentifier)
    def getCertificateType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateType", certificateType)
    def getThumbprint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("thumbprint", thumbprint)
    def getValidFrom: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidTill: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("validTill", validTill)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.Certificate
  ) extends zio.aws.docdb.model.Certificate.ReadOnly {
    override val certificateIdentifier: Option[String] =
      scala.Option(impl.certificateIdentifier()).map(value => value: String)
    override val certificateType: Option[String] =
      scala.Option(impl.certificateType()).map(value => value: String)
    override val thumbprint: Option[String] =
      scala.Option(impl.thumbprint()).map(value => value: String)
    override val validFrom: Option[TStamp] = scala
      .Option(impl.validFrom())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val validTill: Option[TStamp] = scala
      .Option(impl.validTill())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val certificateArn: Option[String] =
      scala.Option(impl.certificateArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.Certificate
  ): zio.aws.docdb.model.Certificate.ReadOnly = new Wrapper(impl)
}
