package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.{BooleanOptional, IntegerOptional}
import scala.jdk.CollectionConverters._
final case class RestoreDbClusterFromSnapshotRequest(
    availabilityZones: Option[Iterable[String]] = None,
    dbClusterIdentifier: String,
    snapshotIdentifier: String,
    engine: String,
    engineVersion: Option[String] = None,
    port: Option[IntegerOptional] = None,
    dbSubnetGroupName: Option[String] = None,
    vpcSecurityGroupIds: Option[Iterable[String]] = None,
    tags: Option[Iterable[zio.aws.docdb.model.Tag]] = None,
    kmsKeyId: Option[String] = None,
    enableCloudwatchLogsExports: Option[Iterable[String]] = None,
    deletionProtection: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotRequest = {
    import RestoreDbClusterFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotRequest
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .snapshotIdentifier(snapshotIdentifier: java.lang.String)
      .engine(engine: java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        deletionProtection.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.RestoreDbClusterFromSnapshotRequest.ReadOnly =
    zio.aws.docdb.model.RestoreDbClusterFromSnapshotRequest
      .wrap(buildAwsValue())
}
object RestoreDbClusterFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.RestoreDbClusterFromSnapshotRequest =
      zio.aws.docdb.model.RestoreDbClusterFromSnapshotRequest(
        availabilityZones.map(value => value),
        dbClusterIdentifier,
        snapshotIdentifier,
        engine,
        engineVersion.map(value => value),
        port.map(value => value),
        dbSubnetGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        deletionProtection.map(value => value)
      )
    def availabilityZones: Option[List[String]]
    def dbClusterIdentifier: String
    def snapshotIdentifier: String
    def engine: String
    def engineVersion: Option[String]
    def port: Option[IntegerOptional]
    def dbSubnetGroupName: Option[String]
    def vpcSecurityGroupIds: Option[List[String]]
    def tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]]
    def kmsKeyId: Option[String]
    def enableCloudwatchLogsExports: Option[List[String]]
    def deletionProtection: Option[BooleanOptional]
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotIdentifier)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.docdb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotRequest
  ) extends zio.aws.docdb.model.RestoreDbClusterFromSnapshotRequest.ReadOnly {
    override val availabilityZones: Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val snapshotIdentifier: String = impl.snapshotIdentifier(): String
    override val engine: String = impl.engine(): String
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.docdb.model.primitives.IntegerOptional(value))
    override val dbSubnetGroupName: Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val vpcSecurityGroupIds: Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.Tag.wrap(item)
        }.toList
      )
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val enableCloudwatchLogsExports: Option[List[String]] = scala
      .Option(impl.enableCloudwatchLogsExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val deletionProtection: Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.docdb.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotRequest
  ): zio.aws.docdb.model.RestoreDbClusterFromSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
