package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Parameter(
    parameterName: Option[String] = None,
    parameterValue: Option[String] = None,
    description: Option[String] = None,
    source: Option[String] = None,
    applyType: Option[String] = None,
    dataType: Option[String] = None,
    allowedValues: Option[String] = None,
    isModifiable: Option[Boolean] = None,
    minimumEngineVersion: Option[String] = None,
    applyMethod: Option[zio.aws.docdb.model.ApplyMethod] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Parameter
      .builder()
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(parameterValue.map(value => value: java.lang.String))(
        _.parameterValue
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(applyType.map(value => value: java.lang.String))(
        _.applyType
      )
      .optionallyWith(dataType.map(value => value: java.lang.String))(
        _.dataType
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(
        _.isModifiable
      )
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(applyMethod.map(value => value.unwrap))(_.applyMethod)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.Parameter.ReadOnly =
    zio.aws.docdb.model.Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.docdb.model.Parameter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.Parameter =
      zio.aws.docdb.model.Parameter(
        parameterName.map(value => value),
        parameterValue.map(value => value),
        description.map(value => value),
        source.map(value => value),
        applyType.map(value => value),
        dataType.map(value => value),
        allowedValues.map(value => value),
        isModifiable.map(value => value),
        minimumEngineVersion.map(value => value),
        applyMethod.map(value => value)
      )
    def parameterName: Option[String]
    def parameterValue: Option[String]
    def description: Option[String]
    def source: Option[String]
    def applyType: Option[String]
    def dataType: Option[String]
    def allowedValues: Option[String]
    def isModifiable: Option[Boolean]
    def minimumEngineVersion: Option[String]
    def applyMethod: Option[zio.aws.docdb.model.ApplyMethod]
    def getParameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getParameterValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterValue", parameterValue)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getApplyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyType", applyType)
    def getDataType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getIsModifiable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isModifiable", isModifiable)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
    def getApplyMethod: ZIO[Any, AwsError, zio.aws.docdb.model.ApplyMethod] =
      AwsError.unwrapOptionField("applyMethod", applyMethod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.Parameter
  ) extends zio.aws.docdb.model.Parameter.ReadOnly {
    override val parameterName: Option[String] =
      scala.Option(impl.parameterName()).map(value => value: String)
    override val parameterValue: Option[String] =
      scala.Option(impl.parameterValue()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val source: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override val applyType: Option[String] =
      scala.Option(impl.applyType()).map(value => value: String)
    override val dataType: Option[String] =
      scala.Option(impl.dataType()).map(value => value: String)
    override val allowedValues: Option[String] =
      scala.Option(impl.allowedValues()).map(value => value: String)
    override val isModifiable: Option[Boolean] =
      scala.Option(impl.isModifiable()).map(value => value: Boolean)
    override val minimumEngineVersion: Option[String] =
      scala.Option(impl.minimumEngineVersion()).map(value => value: String)
    override val applyMethod: Option[zio.aws.docdb.model.ApplyMethod] = scala
      .Option(impl.applyMethod())
      .map(value => zio.aws.docdb.model.ApplyMethod.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.Parameter
  ): zio.aws.docdb.model.Parameter.ReadOnly = new Wrapper(impl)
}
