package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OrderableDBInstanceOption(
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    dbInstanceClass: Option[String] = None,
    licenseModel: Option[String] = None,
    availabilityZones: Option[Iterable[zio.aws.docdb.model.AvailabilityZone]] =
      None,
    vpc: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption = {
    import OrderableDBInstanceOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(vpc.map(value => value: java.lang.Boolean))(_.vpc)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.OrderableDBInstanceOption.ReadOnly =
    zio.aws.docdb.model.OrderableDBInstanceOption.wrap(buildAwsValue())
}
object OrderableDBInstanceOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.OrderableDBInstanceOption =
      zio.aws.docdb.model.OrderableDBInstanceOption(
        engine.map(value => value),
        engineVersion.map(value => value),
        dbInstanceClass.map(value => value),
        licenseModel.map(value => value),
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpc.map(value => value)
      )
    def engine: Option[String]
    def engineVersion: Option[String]
    def dbInstanceClass: Option[String]
    def licenseModel: Option[String]
    def availabilityZones
        : Option[List[zio.aws.docdb.model.AvailabilityZone.ReadOnly]]
    def vpc: Option[Boolean]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getVpc: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("vpc", vpc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption
  ) extends zio.aws.docdb.model.OrderableDBInstanceOption.ReadOnly {
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val dbInstanceClass: Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val licenseModel: Option[String] =
      scala.Option(impl.licenseModel()).map(value => value: String)
    override val availabilityZones
        : Option[List[zio.aws.docdb.model.AvailabilityZone.ReadOnly]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.AvailabilityZone.wrap(item)
        }.toList
      )
    override val vpc: Option[Boolean] =
      scala.Option(impl.vpc()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption
  ): zio.aws.docdb.model.OrderableDBInstanceOption.ReadOnly = new Wrapper(impl)
}
