package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters._
final case class ModifyEventSubscriptionRequest(
    subscriptionName: String,
    snsTopicArn: Option[String] = None,
    sourceType: Option[String] = None,
    eventCategories: Option[Iterable[String]] = None,
    enabled: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionRequest = {
    import ModifyEventSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionRequest
      .builder()
      .subscriptionName(subscriptionName: java.lang.String)
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .optionallyWith(
        enabled.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.ModifyEventSubscriptionRequest.ReadOnly =
    zio.aws.docdb.model.ModifyEventSubscriptionRequest.wrap(buildAwsValue())
}
object ModifyEventSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ModifyEventSubscriptionRequest =
      zio.aws.docdb.model.ModifyEventSubscriptionRequest(
        subscriptionName,
        snsTopicArn.map(value => value),
        sourceType.map(value => value),
        eventCategories.map(value => value),
        enabled.map(value => value)
      )
    def subscriptionName: String
    def snsTopicArn: Option[String]
    def sourceType: Option[String]
    def eventCategories: Option[List[String]]
    def enabled: Option[BooleanOptional]
    def getSubscriptionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subscriptionName)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
    def getEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionRequest
  ) extends zio.aws.docdb.model.ModifyEventSubscriptionRequest.ReadOnly {
    override val subscriptionName: String = impl.subscriptionName(): String
    override val snsTopicArn: Option[String] =
      scala.Option(impl.snsTopicArn()).map(value => value: String)
    override val sourceType: Option[String] =
      scala.Option(impl.sourceType()).map(value => value: String)
    override val eventCategories: Option[List[String]] = scala
      .Option(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val enabled: Option[BooleanOptional] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.docdb.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionRequest
  ): zio.aws.docdb.model.ModifyEventSubscriptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
