package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterParameterGroupResponse(
    dbClusterParameterGroupName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse = {
    import ModifyDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse
      .builder()
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.ModifyDbClusterParameterGroupResponse.ReadOnly =
    zio.aws.docdb.model.ModifyDbClusterParameterGroupResponse
      .wrap(buildAwsValue())
}
object ModifyDbClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ModifyDbClusterParameterGroupResponse =
      zio.aws.docdb.model.ModifyDbClusterParameterGroupResponse(
        dbClusterParameterGroupName.map(value => value)
      )
    def dbClusterParameterGroupName: Option[String]
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse
  ) extends zio.aws.docdb.model.ModifyDbClusterParameterGroupResponse.ReadOnly {
    override val dbClusterParameterGroupName: Option[String] = scala
      .Option(impl.dbClusterParameterGroupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse
  ): zio.aws.docdb.model.ModifyDbClusterParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
