package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tagList: Option[Iterable[zio.aws.docdb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.docdb.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ListTagsForResourceResponse =
      zio.aws.docdb.model.ListTagsForResourceResponse(
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tagList: Option[List[zio.aws.docdb.model.Tag.ReadOnly]]
    def getTagList: ZIO[Any, AwsError, List[zio.aws.docdb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse
  ) extends zio.aws.docdb.model.ListTagsForResourceResponse.ReadOnly {
    override val tagList: Option[List[zio.aws.docdb.model.Tag.ReadOnly]] = scala
      .Option(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse
  ): zio.aws.docdb.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
