package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class Endpoint(
    address: Option[String] = None,
    port: Option[Integer] = None,
    hostedZoneId: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.Endpoint = {
    import Endpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Endpoint
      .builder()
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .optionallyWith(
        port.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.port)
      .optionallyWith(hostedZoneId.map(value => value: java.lang.String))(
        _.hostedZoneId
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.Endpoint.ReadOnly =
    zio.aws.docdb.model.Endpoint.wrap(buildAwsValue())
}
object Endpoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.docdb.model.Endpoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.Endpoint = zio.aws.docdb.model.Endpoint(
      address.map(value => value),
      port.map(value => value),
      hostedZoneId.map(value => value)
    )
    def address: Option[String]
    def port: Option[Integer]
    def hostedZoneId: Option[String]
    def getAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("address", address)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getHostedZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.Endpoint
  ) extends zio.aws.docdb.model.Endpoint.ReadOnly {
    override val address: Option[String] =
      scala.Option(impl.address()).map(value => value: String)
    override val port: Option[Integer] = scala
      .Option(impl.port())
      .map(value => zio.aws.docdb.model.primitives.Integer(value))
    override val hostedZoneId: Option[String] =
      scala.Option(impl.hostedZoneId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.Endpoint
  ): zio.aws.docdb.model.Endpoint.ReadOnly = new Wrapper(impl)
}
