package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEngineDefaultClusterParametersResponse(
    engineDefaults: Option[zio.aws.docdb.model.EngineDefaults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse = {
    import DescribeEngineDefaultClusterParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse
      .builder()
      .optionallyWith(engineDefaults.map(value => value.buildAwsValue()))(
        _.engineDefaults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly =
    zio.aws.docdb.model.DescribeEngineDefaultClusterParametersResponse
      .wrap(buildAwsValue())
}
object DescribeEngineDefaultClusterParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.docdb.model.DescribeEngineDefaultClusterParametersResponse =
      zio.aws.docdb.model.DescribeEngineDefaultClusterParametersResponse(
        engineDefaults.map(value => value.asEditable)
      )
    def engineDefaults: Option[zio.aws.docdb.model.EngineDefaults.ReadOnly]
    def getEngineDefaults
        : ZIO[Any, AwsError, zio.aws.docdb.model.EngineDefaults.ReadOnly] =
      AwsError.unwrapOptionField("engineDefaults", engineDefaults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse
  ) extends zio.aws.docdb.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly {
    override val engineDefaults
        : Option[zio.aws.docdb.model.EngineDefaults.ReadOnly] = scala
      .Option(impl.engineDefaults())
      .map(value => zio.aws.docdb.model.EngineDefaults.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse
  ): zio.aws.docdb.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly =
    new Wrapper(impl)
}
