package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbInstancesResponse(
    marker: Option[String] = None,
    dbInstances: Option[Iterable[zio.aws.docdb.model.DBInstance]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse = {
    import DescribeDbInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbInstances)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DescribeDbInstancesResponse.ReadOnly =
    zio.aws.docdb.model.DescribeDbInstancesResponse.wrap(buildAwsValue())
}
object DescribeDbInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DescribeDbInstancesResponse =
      zio.aws.docdb.model.DescribeDbInstancesResponse(
        marker.map(value => value),
        dbInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def dbInstances: Option[List[zio.aws.docdb.model.DBInstance.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbInstances
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.DBInstance.ReadOnly]] =
      AwsError.unwrapOptionField("dbInstances", dbInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse
  ) extends zio.aws.docdb.model.DescribeDbInstancesResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val dbInstances
        : Option[List[zio.aws.docdb.model.DBInstance.ReadOnly]] = scala
      .Option(impl.dbInstances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.DBInstance.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse
  ): zio.aws.docdb.model.DescribeDbInstancesResponse.ReadOnly = new Wrapper(
    impl
  )
}
