package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteGlobalClusterResponse(
    globalCluster: Option[zio.aws.docdb.model.GlobalCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterResponse = {
    import DeleteGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterResponse
      .builder()
      .optionallyWith(globalCluster.map(value => value.buildAwsValue()))(
        _.globalCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DeleteGlobalClusterResponse.ReadOnly =
    zio.aws.docdb.model.DeleteGlobalClusterResponse.wrap(buildAwsValue())
}
object DeleteGlobalClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DeleteGlobalClusterResponse =
      zio.aws.docdb.model.DeleteGlobalClusterResponse(
        globalCluster.map(value => value.asEditable)
      )
    def globalCluster: Option[zio.aws.docdb.model.GlobalCluster.ReadOnly]
    def getGlobalCluster
        : ZIO[Any, AwsError, zio.aws.docdb.model.GlobalCluster.ReadOnly] =
      AwsError.unwrapOptionField("globalCluster", globalCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterResponse
  ) extends zio.aws.docdb.model.DeleteGlobalClusterResponse.ReadOnly {
    override val globalCluster
        : Option[zio.aws.docdb.model.GlobalCluster.ReadOnly] = scala
      .Option(impl.globalCluster())
      .map(value => zio.aws.docdb.model.GlobalCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterResponse
  ): zio.aws.docdb.model.DeleteGlobalClusterResponse.ReadOnly = new Wrapper(
    impl
  )
}
