package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.docdb.model.primitives.{Integer, TStamp}
import scala.jdk.CollectionConverters._
final case class DBClusterSnapshot(
    availabilityZones: Option[Iterable[String]] = None,
    dbClusterSnapshotIdentifier: Option[String] = None,
    dbClusterIdentifier: Option[String] = None,
    snapshotCreateTime: Option[TStamp] = None,
    engine: Option[String] = None,
    status: Option[String] = None,
    port: Option[Integer] = None,
    vpcId: Option[String] = None,
    clusterCreateTime: Option[TStamp] = None,
    masterUsername: Option[String] = None,
    engineVersion: Option[String] = None,
    snapshotType: Option[String] = None,
    percentProgress: Option[Integer] = None,
    storageEncrypted: Option[Boolean] = None,
    kmsKeyId: Option[String] = None,
    dbClusterSnapshotArn: Option[String] = None,
    sourceDBClusterSnapshotArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBClusterSnapshot = {
    import DBClusterSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBClusterSnapshot
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        dbClusterSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterSnapshotIdentifier)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        snapshotCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.snapshotCreateTime)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        port.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.port)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        clusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.clusterCreateTime)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(snapshotType.map(value => value: java.lang.String))(
        _.snapshotType
      )
      .optionallyWith(
        percentProgress.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.percentProgress)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        dbClusterSnapshotArn.map(value => value: java.lang.String)
      )(_.dbClusterSnapshotArn)
      .optionallyWith(
        sourceDBClusterSnapshotArn.map(value => value: java.lang.String)
      )(_.sourceDBClusterSnapshotArn)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBClusterSnapshot.ReadOnly =
    zio.aws.docdb.model.DBClusterSnapshot.wrap(buildAwsValue())
}
object DBClusterSnapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DBClusterSnapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBClusterSnapshot =
      zio.aws.docdb.model.DBClusterSnapshot(
        availabilityZones.map(value => value),
        dbClusterSnapshotIdentifier.map(value => value),
        dbClusterIdentifier.map(value => value),
        snapshotCreateTime.map(value => value),
        engine.map(value => value),
        status.map(value => value),
        port.map(value => value),
        vpcId.map(value => value),
        clusterCreateTime.map(value => value),
        masterUsername.map(value => value),
        engineVersion.map(value => value),
        snapshotType.map(value => value),
        percentProgress.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        dbClusterSnapshotArn.map(value => value),
        sourceDBClusterSnapshotArn.map(value => value)
      )
    def availabilityZones: Option[List[String]]
    def dbClusterSnapshotIdentifier: Option[String]
    def dbClusterIdentifier: Option[String]
    def snapshotCreateTime: Option[TStamp]
    def engine: Option[String]
    def status: Option[String]
    def port: Option[Integer]
    def vpcId: Option[String]
    def clusterCreateTime: Option[TStamp]
    def masterUsername: Option[String]
    def engineVersion: Option[String]
    def snapshotType: Option[String]
    def percentProgress: Option[Integer]
    def storageEncrypted: Option[Boolean]
    def kmsKeyId: Option[String]
    def dbClusterSnapshotArn: Option[String]
    def sourceDBClusterSnapshotArn: Option[String]
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getDbClusterSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterSnapshotIdentifier",
        dbClusterSnapshotIdentifier
      )
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getSnapshotCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTime)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getClusterCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getSnapshotType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getPercentProgress: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbClusterSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterSnapshotArn", dbClusterSnapshotArn)
    def getSourceDBClusterSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceDBClusterSnapshotArn",
        sourceDBClusterSnapshotArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterSnapshot
  ) extends zio.aws.docdb.model.DBClusterSnapshot.ReadOnly {
    override val availabilityZones: Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dbClusterSnapshotIdentifier: Option[String] = scala
      .Option(impl.dbClusterSnapshotIdentifier())
      .map(value => value: String)
    override val dbClusterIdentifier: Option[String] =
      scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override val snapshotCreateTime: Option[TStamp] = scala
      .Option(impl.snapshotCreateTime())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val port: Option[Integer] = scala
      .Option(impl.port())
      .map(value => zio.aws.docdb.model.primitives.Integer(value))
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val clusterCreateTime: Option[TStamp] = scala
      .Option(impl.clusterCreateTime())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val masterUsername: Option[String] =
      scala.Option(impl.masterUsername()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val snapshotType: Option[String] =
      scala.Option(impl.snapshotType()).map(value => value: String)
    override val percentProgress: Option[Integer] = scala
      .Option(impl.percentProgress())
      .map(value => zio.aws.docdb.model.primitives.Integer(value))
    override val storageEncrypted: Option[Boolean] =
      scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val dbClusterSnapshotArn: Option[String] =
      scala.Option(impl.dbClusterSnapshotArn()).map(value => value: String)
    override val sourceDBClusterSnapshotArn: Option[String] = scala
      .Option(impl.sourceDBClusterSnapshotArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterSnapshot
  ): zio.aws.docdb.model.DBClusterSnapshot.ReadOnly = new Wrapper(impl)
}
