package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDbClusterResponse(
    dbCluster: Option[zio.aws.docdb.model.DBCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse = {
    import CreateDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.CreateDbClusterResponse.ReadOnly =
    zio.aws.docdb.model.CreateDbClusterResponse.wrap(buildAwsValue())
}
object CreateDbClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CreateDbClusterResponse =
      zio.aws.docdb.model
        .CreateDbClusterResponse(dbCluster.map(value => value.asEditable))
    def dbCluster: Option[zio.aws.docdb.model.DBCluster.ReadOnly]
    def getDbCluster
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse
  ) extends zio.aws.docdb.model.CreateDbClusterResponse.ReadOnly {
    override val dbCluster: Option[zio.aws.docdb.model.DBCluster.ReadOnly] =
      scala
        .Option(impl.dbCluster())
        .map(value => zio.aws.docdb.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse
  ): zio.aws.docdb.model.CreateDbClusterResponse.ReadOnly = new Wrapper(impl)
}
