package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDbClusterParameterGroupRequest(
    dbClusterParameterGroupName: String,
    dbParameterGroupFamily: String,
    description: String,
    tags: Option[Iterable[zio.aws.docdb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest = {
    import CreateDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest
      .builder()
      .dbClusterParameterGroupName(
        dbClusterParameterGroupName: java.lang.String
      )
      .dbParameterGroupFamily(dbParameterGroupFamily: java.lang.String)
      .description(description: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.CreateDbClusterParameterGroupRequest.ReadOnly =
    zio.aws.docdb.model.CreateDbClusterParameterGroupRequest
      .wrap(buildAwsValue())
}
object CreateDbClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CreateDbClusterParameterGroupRequest =
      zio.aws.docdb.model.CreateDbClusterParameterGroupRequest(
        dbClusterParameterGroupName,
        dbParameterGroupFamily,
        description,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbClusterParameterGroupName: String
    def dbParameterGroupFamily: String
    def description: String
    def tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]]
    def getDbClusterParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterParameterGroupName)
    def getDbParameterGroupFamily: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbParameterGroupFamily)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.docdb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest
  ) extends zio.aws.docdb.model.CreateDbClusterParameterGroupRequest.ReadOnly {
    override val dbClusterParameterGroupName: String =
      impl.dbClusterParameterGroupName(): String
    override val dbParameterGroupFamily: String =
      impl.dbParameterGroupFamily(): String
    override val description: String = impl.description(): String
    override val tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest
  ): zio.aws.docdb.model.CreateDbClusterParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
