package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResetDbClusterParameterGroupResponse(
    dbClusterParameterGroupName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse = {
    import ResetDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse
      .builder()
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.ResetDbClusterParameterGroupResponse.ReadOnly =
    zio.aws.docdb.model.ResetDbClusterParameterGroupResponse
      .wrap(buildAwsValue())
}
object ResetDbClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ResetDbClusterParameterGroupResponse =
      zio.aws.docdb.model.ResetDbClusterParameterGroupResponse(
        dbClusterParameterGroupName.map(value => value)
      )
    def dbClusterParameterGroupName: Option[String]
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse
  ) extends zio.aws.docdb.model.ResetDbClusterParameterGroupResponse.ReadOnly {
    override val dbClusterParameterGroupName: Option[String] = scala
      .Option(impl.dbClusterParameterGroupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse
  ): zio.aws.docdb.model.ResetDbClusterParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
