package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyDbInstanceResponse(
    dbInstance: Option[zio.aws.docdb.model.DBInstance] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyDbInstanceResponse = {
    import ModifyDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbInstanceResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.ModifyDbInstanceResponse.ReadOnly =
    zio.aws.docdb.model.ModifyDbInstanceResponse.wrap(buildAwsValue())
}
object ModifyDbInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyDbInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ModifyDbInstanceResponse =
      zio.aws.docdb.model
        .ModifyDbInstanceResponse(dbInstance.map(value => value.asEditable))
    def dbInstance: Option[zio.aws.docdb.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbInstanceResponse
  ) extends zio.aws.docdb.model.ModifyDbInstanceResponse.ReadOnly {
    override val dbInstance: Option[zio.aws.docdb.model.DBInstance.ReadOnly] =
      scala
        .Option(impl.dbInstance())
        .map(value => zio.aws.docdb.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbInstanceResponse
  ): zio.aws.docdb.model.ModifyDbInstanceResponse.ReadOnly = new Wrapper(impl)
}
