package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.{BooleanOptional, GlobalClusterIdentifier}
import scala.jdk.CollectionConverters._
final case class GlobalCluster(
    globalClusterIdentifier: Option[GlobalClusterIdentifier] = None,
    globalClusterResourceId: Option[String] = None,
    globalClusterArn: Option[String] = None,
    status: Option[String] = None,
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    databaseName: Option[String] = None,
    storageEncrypted: Option[BooleanOptional] = None,
    deletionProtection: Option[BooleanOptional] = None,
    globalClusterMembers: Option[
      Iterable[zio.aws.docdb.model.GlobalClusterMember]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.GlobalCluster = {
    import GlobalCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.GlobalCluster
      .builder()
      .optionallyWith(
        globalClusterIdentifier.map(value =>
          GlobalClusterIdentifier.unwrap(value): java.lang.String
        )
      )(_.globalClusterIdentifier)
      .optionallyWith(
        globalClusterResourceId.map(value => value: java.lang.String)
      )(_.globalClusterResourceId)
      .optionallyWith(globalClusterArn.map(value => value: java.lang.String))(
        _.globalClusterArn
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        storageEncrypted.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.storageEncrypted)
      .optionallyWith(
        deletionProtection.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .optionallyWith(
        globalClusterMembers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalClusterMembers)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.GlobalCluster.ReadOnly =
    zio.aws.docdb.model.GlobalCluster.wrap(buildAwsValue())
}
object GlobalCluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.GlobalCluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.GlobalCluster =
      zio.aws.docdb.model.GlobalCluster(
        globalClusterIdentifier.map(value => value),
        globalClusterResourceId.map(value => value),
        globalClusterArn.map(value => value),
        status.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        databaseName.map(value => value),
        storageEncrypted.map(value => value),
        deletionProtection.map(value => value),
        globalClusterMembers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalClusterIdentifier: Option[GlobalClusterIdentifier]
    def globalClusterResourceId: Option[String]
    def globalClusterArn: Option[String]
    def status: Option[String]
    def engine: Option[String]
    def engineVersion: Option[String]
    def databaseName: Option[String]
    def storageEncrypted: Option[BooleanOptional]
    def deletionProtection: Option[BooleanOptional]
    def globalClusterMembers
        : Option[List[zio.aws.docdb.model.GlobalClusterMember.ReadOnly]]
    def getGlobalClusterIdentifier
        : ZIO[Any, AwsError, GlobalClusterIdentifier] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
    def getGlobalClusterResourceId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalClusterResourceId", globalClusterResourceId)
    def getGlobalClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("globalClusterArn", globalClusterArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getGlobalClusterMembers: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.GlobalClusterMember.ReadOnly
    ]] =
      AwsError.unwrapOptionField("globalClusterMembers", globalClusterMembers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.GlobalCluster
  ) extends zio.aws.docdb.model.GlobalCluster.ReadOnly {
    override val globalClusterIdentifier: Option[GlobalClusterIdentifier] =
      scala
        .Option(impl.globalClusterIdentifier())
        .map(value =>
          zio.aws.docdb.model.primitives.GlobalClusterIdentifier(value)
        )
    override val globalClusterResourceId: Option[String] =
      scala.Option(impl.globalClusterResourceId()).map(value => value: String)
    override val globalClusterArn: Option[String] =
      scala.Option(impl.globalClusterArn()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val databaseName: Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val storageEncrypted: Option[BooleanOptional] = scala
      .Option(impl.storageEncrypted())
      .map(value => zio.aws.docdb.model.primitives.BooleanOptional(value))
    override val deletionProtection: Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.docdb.model.primitives.BooleanOptional(value))
    override val globalClusterMembers
        : Option[List[zio.aws.docdb.model.GlobalClusterMember.ReadOnly]] = scala
      .Option(impl.globalClusterMembers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.GlobalClusterMember.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.GlobalCluster
  ): zio.aws.docdb.model.GlobalCluster.ReadOnly = new Wrapper(impl)
}
