package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEventCategoriesRequest(
    sourceType: Option[String] = None,
    filters: Option[Iterable[zio.aws.docdb.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest = {
    import DescribeEventCategoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest
      .builder()
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DescribeEventCategoriesRequest.ReadOnly =
    zio.aws.docdb.model.DescribeEventCategoriesRequest.wrap(buildAwsValue())
}
object DescribeEventCategoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DescribeEventCategoriesRequest =
      zio.aws.docdb.model.DescribeEventCategoriesRequest(
        sourceType.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceType: Option[String]
    def filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]]
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest
  ) extends zio.aws.docdb.model.DescribeEventCategoriesRequest.ReadOnly {
    override val sourceType: Option[String] =
      scala.Option(impl.sourceType()).map(value => value: String)
    override val filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest
  ): zio.aws.docdb.model.DescribeEventCategoriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
