package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterSnapshotsResponse(
    marker: Option[String] = None,
    dbClusterSnapshots: Option[
      Iterable[zio.aws.docdb.model.DBClusterSnapshot]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse = {
    import DescribeDbClusterSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbClusterSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterSnapshots)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.DescribeDbClusterSnapshotsResponse.ReadOnly =
    zio.aws.docdb.model.DescribeDbClusterSnapshotsResponse.wrap(buildAwsValue())
}
object DescribeDbClusterSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DescribeDbClusterSnapshotsResponse =
      zio.aws.docdb.model.DescribeDbClusterSnapshotsResponse(
        marker.map(value => value),
        dbClusterSnapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def dbClusterSnapshots
        : Option[List[zio.aws.docdb.model.DBClusterSnapshot.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbClusterSnapshots: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.DBClusterSnapshot.ReadOnly
    ]] = AwsError.unwrapOptionField("dbClusterSnapshots", dbClusterSnapshots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse
  ) extends zio.aws.docdb.model.DescribeDbClusterSnapshotsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val dbClusterSnapshots
        : Option[List[zio.aws.docdb.model.DBClusterSnapshot.ReadOnly]] = scala
      .Option(impl.dbClusterSnapshots())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.DBClusterSnapshot.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse
  ): zio.aws.docdb.model.DescribeDbClusterSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
