package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDbSubnetGroupRequest(dbSubnetGroupName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest = {
    import DeleteDbSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest
      .builder()
      .dbSubnetGroupName(dbSubnetGroupName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DeleteDbSubnetGroupRequest.ReadOnly =
    zio.aws.docdb.model.DeleteDbSubnetGroupRequest.wrap(buildAwsValue())
}
object DeleteDbSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DeleteDbSubnetGroupRequest =
      zio.aws.docdb.model.DeleteDbSubnetGroupRequest(dbSubnetGroupName)
    def dbSubnetGroupName: String
    def getDbSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSubnetGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest
  ) extends zio.aws.docdb.model.DeleteDbSubnetGroupRequest.ReadOnly {
    override val dbSubnetGroupName: String = impl.dbSubnetGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest
  ): zio.aws.docdb.model.DeleteDbSubnetGroupRequest.ReadOnly = new Wrapper(impl)
}
