package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DBClusterParameterGroup(
    dbClusterParameterGroupName: Option[String] = None,
    dbParameterGroupFamily: Option[String] = None,
    description: Option[String] = None,
    dbClusterParameterGroupArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBClusterParameterGroup = {
    import DBClusterParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBClusterParameterGroup
      .builder()
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        dbClusterParameterGroupArn.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly =
    zio.aws.docdb.model.DBClusterParameterGroup.wrap(buildAwsValue())
}
object DBClusterParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DBClusterParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBClusterParameterGroup =
      zio.aws.docdb.model.DBClusterParameterGroup(
        dbClusterParameterGroupName.map(value => value),
        dbParameterGroupFamily.map(value => value),
        description.map(value => value),
        dbClusterParameterGroupArn.map(value => value)
      )
    def dbClusterParameterGroupName: Option[String]
    def dbParameterGroupFamily: Option[String]
    def description: Option[String]
    def dbClusterParameterGroupArn: Option[String]
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDbClusterParameterGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupArn",
        dbClusterParameterGroupArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterParameterGroup
  ) extends zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly {
    override val dbClusterParameterGroupName: Option[String] = scala
      .Option(impl.dbClusterParameterGroupName())
      .map(value => value: String)
    override val dbParameterGroupFamily: Option[String] =
      scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val dbClusterParameterGroupArn: Option[String] = scala
      .Option(impl.dbClusterParameterGroupArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterParameterGroup
  ): zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly = new Wrapper(impl)
}
