package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.{BooleanOptional, GlobalClusterIdentifier}
import scala.jdk.CollectionConverters._
final case class CreateGlobalClusterRequest(
    globalClusterIdentifier: GlobalClusterIdentifier,
    sourceDBClusterIdentifier: Option[String] = None,
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    deletionProtection: Option[BooleanOptional] = None,
    databaseName: Option[String] = None,
    storageEncrypted: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CreateGlobalClusterRequest = {
    import CreateGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateGlobalClusterRequest
      .builder()
      .globalClusterIdentifier(
        GlobalClusterIdentifier.unwrap(
          globalClusterIdentifier
        ): java.lang.String
      )
      .optionallyWith(
        sourceDBClusterIdentifier.map(value => value: java.lang.String)
      )(_.sourceDBClusterIdentifier)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        deletionProtection.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        storageEncrypted.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.storageEncrypted)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.CreateGlobalClusterRequest.ReadOnly =
    zio.aws.docdb.model.CreateGlobalClusterRequest.wrap(buildAwsValue())
}
object CreateGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CreateGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CreateGlobalClusterRequest =
      zio.aws.docdb.model.CreateGlobalClusterRequest(
        globalClusterIdentifier,
        sourceDBClusterIdentifier.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        deletionProtection.map(value => value),
        databaseName.map(value => value),
        storageEncrypted.map(value => value)
      )
    def globalClusterIdentifier: GlobalClusterIdentifier
    def sourceDBClusterIdentifier: Option[String]
    def engine: Option[String]
    def engineVersion: Option[String]
    def deletionProtection: Option[BooleanOptional]
    def databaseName: Option[String]
    def storageEncrypted: Option[BooleanOptional]
    def getGlobalClusterIdentifier: ZIO[Any, Nothing, GlobalClusterIdentifier] =
      ZIO.succeed(globalClusterIdentifier)
    def getSourceDBClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("sourceDBClusterIdentifier", sourceDBClusterIdentifier)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CreateGlobalClusterRequest
  ) extends zio.aws.docdb.model.CreateGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: GlobalClusterIdentifier =
      zio.aws.docdb.model.primitives
        .GlobalClusterIdentifier(impl.globalClusterIdentifier())
    override val sourceDBClusterIdentifier: Option[String] =
      scala.Option(impl.sourceDBClusterIdentifier()).map(value => value: String)
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val deletionProtection: Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.docdb.model.primitives.BooleanOptional(value))
    override val databaseName: Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val storageEncrypted: Option[BooleanOptional] = scala
      .Option(impl.storageEncrypted())
      .map(value => zio.aws.docdb.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CreateGlobalClusterRequest
  ): zio.aws.docdb.model.CreateGlobalClusterRequest.ReadOnly = new Wrapper(impl)
}
