package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDbSubnetGroupResponse(
    dbSubnetGroup: Option[zio.aws.docdb.model.DBSubnetGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse = {
    import CreateDbSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse
      .builder()
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.CreateDbSubnetGroupResponse.ReadOnly =
    zio.aws.docdb.model.CreateDbSubnetGroupResponse.wrap(buildAwsValue())
}
object CreateDbSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CreateDbSubnetGroupResponse =
      zio.aws.docdb.model.CreateDbSubnetGroupResponse(
        dbSubnetGroup.map(value => value.asEditable)
      )
    def dbSubnetGroup: Option[zio.aws.docdb.model.DBSubnetGroup.ReadOnly]
    def getDbSubnetGroup
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBSubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse
  ) extends zio.aws.docdb.model.CreateDbSubnetGroupResponse.ReadOnly {
    override val dbSubnetGroup
        : Option[zio.aws.docdb.model.DBSubnetGroup.ReadOnly] = scala
      .Option(impl.dbSubnetGroup())
      .map(value => zio.aws.docdb.model.DBSubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse
  ): zio.aws.docdb.model.CreateDbSubnetGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
