package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.{IntegerOptional, BooleanOptional}
import scala.jdk.CollectionConverters._
final case class CreateDbInstanceRequest(
    dbInstanceIdentifier: String,
    dbInstanceClass: String,
    engine: String,
    availabilityZone: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    autoMinorVersionUpgrade: Option[BooleanOptional] = None,
    tags: Option[Iterable[zio.aws.docdb.model.Tag]] = None,
    dbClusterIdentifier: String,
    promotionTier: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest = {
    import CreateDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .dbInstanceClass(dbInstanceClass: java.lang.String)
      .engine(engine: java.lang.String)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        promotionTier.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.promotionTier)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.CreateDbInstanceRequest.ReadOnly =
    zio.aws.docdb.model.CreateDbInstanceRequest.wrap(buildAwsValue())
}
object CreateDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CreateDbInstanceRequest =
      zio.aws.docdb.model.CreateDbInstanceRequest(
        dbInstanceIdentifier,
        dbInstanceClass,
        engine,
        availabilityZone.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbClusterIdentifier,
        promotionTier.map(value => value)
      )
    def dbInstanceIdentifier: String
    def dbInstanceClass: String
    def engine: String
    def availabilityZone: Option[String]
    def preferredMaintenanceWindow: Option[String]
    def autoMinorVersionUpgrade: Option[BooleanOptional]
    def tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]]
    def dbClusterIdentifier: String
    def promotionTier: Option[IntegerOptional]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getDbInstanceClass: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceClass)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.docdb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest
  ) extends zio.aws.docdb.model.CreateDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val dbInstanceClass: String = impl.dbInstanceClass(): String
    override val engine: String = impl.engine(): String
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => zio.aws.docdb.model.primitives.BooleanOptional(value))
    override val tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.Tag.wrap(item)
        }.toList
      )
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val promotionTier: Option[IntegerOptional] = scala
      .Option(impl.promotionTier())
      .map(value => zio.aws.docdb.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest
  ): zio.aws.docdb.model.CreateDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
