package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters._
final case class CopyDbClusterSnapshotRequest(
    sourceDBClusterSnapshotIdentifier: String,
    targetDBClusterSnapshotIdentifier: String,
    kmsKeyId: Option[String] = None,
    preSignedUrl: Option[String] = None,
    copyTags: Option[BooleanOptional] = None,
    tags: Option[Iterable[zio.aws.docdb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest = {
    import CopyDbClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest
      .builder()
      .sourceDBClusterSnapshotIdentifier(
        sourceDBClusterSnapshotIdentifier: java.lang.String
      )
      .targetDBClusterSnapshotIdentifier(
        targetDBClusterSnapshotIdentifier: java.lang.String
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(preSignedUrl.map(value => value: java.lang.String))(
        _.preSignedUrl
      )
      .optionallyWith(
        copyTags.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.copyTags)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.CopyDbClusterSnapshotRequest.ReadOnly =
    zio.aws.docdb.model.CopyDbClusterSnapshotRequest.wrap(buildAwsValue())
}
object CopyDbClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CopyDbClusterSnapshotRequest =
      zio.aws.docdb.model.CopyDbClusterSnapshotRequest(
        sourceDBClusterSnapshotIdentifier,
        targetDBClusterSnapshotIdentifier,
        kmsKeyId.map(value => value),
        preSignedUrl.map(value => value),
        copyTags.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceDBClusterSnapshotIdentifier: String
    def targetDBClusterSnapshotIdentifier: String
    def kmsKeyId: Option[String]
    def preSignedUrl: Option[String]
    def copyTags: Option[BooleanOptional]
    def tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]]
    def getSourceDBClusterSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBClusterSnapshotIdentifier)
    def getTargetDBClusterSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDBClusterSnapshotIdentifier)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPreSignedUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
    def getCopyTags: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTags", copyTags)
    def getTags: ZIO[Any, AwsError, List[zio.aws.docdb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest
  ) extends zio.aws.docdb.model.CopyDbClusterSnapshotRequest.ReadOnly {
    override val sourceDBClusterSnapshotIdentifier: String =
      impl.sourceDBClusterSnapshotIdentifier(): String
    override val targetDBClusterSnapshotIdentifier: String =
      impl.targetDBClusterSnapshotIdentifier(): String
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val preSignedUrl: Option[String] =
      scala.Option(impl.preSignedUrl()).map(value => value: String)
    override val copyTags: Option[BooleanOptional] = scala
      .Option(impl.copyTags())
      .map(value => zio.aws.docdb.model.primitives.BooleanOptional(value))
    override val tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest
  ): zio.aws.docdb.model.CopyDbClusterSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
