package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopyDbClusterParameterGroupRequest(
    sourceDBClusterParameterGroupIdentifier: String,
    targetDBClusterParameterGroupIdentifier: String,
    targetDBClusterParameterGroupDescription: String,
    tags: Option[Iterable[zio.aws.docdb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest = {
    import CopyDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest
      .builder()
      .sourceDBClusterParameterGroupIdentifier(
        sourceDBClusterParameterGroupIdentifier: java.lang.String
      )
      .targetDBClusterParameterGroupIdentifier(
        targetDBClusterParameterGroupIdentifier: java.lang.String
      )
      .targetDBClusterParameterGroupDescription(
        targetDBClusterParameterGroupDescription: java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.CopyDbClusterParameterGroupRequest.ReadOnly =
    zio.aws.docdb.model.CopyDbClusterParameterGroupRequest.wrap(buildAwsValue())
}
object CopyDbClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CopyDbClusterParameterGroupRequest =
      zio.aws.docdb.model.CopyDbClusterParameterGroupRequest(
        sourceDBClusterParameterGroupIdentifier,
        targetDBClusterParameterGroupIdentifier,
        targetDBClusterParameterGroupDescription,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceDBClusterParameterGroupIdentifier: String
    def targetDBClusterParameterGroupIdentifier: String
    def targetDBClusterParameterGroupDescription: String
    def tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]]
    def getSourceDBClusterParameterGroupIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBClusterParameterGroupIdentifier)
    def getTargetDBClusterParameterGroupIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDBClusterParameterGroupIdentifier)
    def getTargetDBClusterParameterGroupDescription: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDBClusterParameterGroupDescription)
    def getTags: ZIO[Any, AwsError, List[zio.aws.docdb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest
  ) extends zio.aws.docdb.model.CopyDbClusterParameterGroupRequest.ReadOnly {
    override val sourceDBClusterParameterGroupIdentifier: String =
      impl.sourceDBClusterParameterGroupIdentifier(): String
    override val targetDBClusterParameterGroupIdentifier: String =
      impl.targetDBClusterParameterGroupIdentifier(): String
    override val targetDBClusterParameterGroupDescription: String =
      impl.targetDBClusterParameterGroupDescription(): String
    override val tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest
  ): zio.aws.docdb.model.CopyDbClusterParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
