package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CloudwatchLogsExportConfiguration(
    enableLogTypes: Option[Iterable[String]] = None,
    disableLogTypes: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CloudwatchLogsExportConfiguration = {
    import CloudwatchLogsExportConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CloudwatchLogsExportConfiguration
      .builder()
      .optionallyWith(
        enableLogTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableLogTypes)
      .optionallyWith(
        disableLogTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.disableLogTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.CloudwatchLogsExportConfiguration.ReadOnly =
    zio.aws.docdb.model.CloudwatchLogsExportConfiguration.wrap(buildAwsValue())
}
object CloudwatchLogsExportConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CloudwatchLogsExportConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CloudwatchLogsExportConfiguration =
      zio.aws.docdb.model.CloudwatchLogsExportConfiguration(
        enableLogTypes.map(value => value),
        disableLogTypes.map(value => value)
      )
    def enableLogTypes: Option[List[String]]
    def disableLogTypes: Option[List[String]]
    def getEnableLogTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("enableLogTypes", enableLogTypes)
    def getDisableLogTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("disableLogTypes", disableLogTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CloudwatchLogsExportConfiguration
  ) extends zio.aws.docdb.model.CloudwatchLogsExportConfiguration.ReadOnly {
    override val enableLogTypes: Option[List[String]] = scala
      .Option(impl.enableLogTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val disableLogTypes: Option[List[String]] = scala
      .Option(impl.disableLogTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CloudwatchLogsExportConfiguration
  ): zio.aws.docdb.model.CloudwatchLogsExportConfiguration.ReadOnly =
    new Wrapper(impl)
}
