package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpgradeTarget(
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    description: Option[String] = None,
    autoUpgrade: Option[Boolean] = None,
    isMajorVersionUpgrade: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.UpgradeTarget = {
    import UpgradeTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.UpgradeTarget
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(autoUpgrade.map(value => value: java.lang.Boolean))(
        _.autoUpgrade
      )
      .optionallyWith(
        isMajorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.isMajorVersionUpgrade)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.UpgradeTarget.ReadOnly =
    zio.aws.docdb.model.UpgradeTarget.wrap(buildAwsValue())
}
object UpgradeTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.UpgradeTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.UpgradeTarget =
      zio.aws.docdb.model.UpgradeTarget(
        engine.map(value => value),
        engineVersion.map(value => value),
        description.map(value => value),
        autoUpgrade.map(value => value),
        isMajorVersionUpgrade.map(value => value)
      )
    def engine: Option[String]
    def engineVersion: Option[String]
    def description: Option[String]
    def autoUpgrade: Option[Boolean]
    def isMajorVersionUpgrade: Option[Boolean]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAutoUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoUpgrade", autoUpgrade)
    def getIsMajorVersionUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isMajorVersionUpgrade", isMajorVersionUpgrade)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.UpgradeTarget
  ) extends zio.aws.docdb.model.UpgradeTarget.ReadOnly {
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val autoUpgrade: Option[Boolean] =
      scala.Option(impl.autoUpgrade()).map(value => value: Boolean)
    override val isMajorVersionUpgrade: Option[Boolean] =
      scala.Option(impl.isMajorVersionUpgrade()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.UpgradeTarget
  ): zio.aws.docdb.model.UpgradeTarget.ReadOnly = new Wrapper(impl)
}
